﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Microsoft.Win32;
using System.IO;

namespace HandlingChange
{
    public partial class Form1 : Form
    {
        string directory;

        public Form1()
        {
            InitializeComponent();
        }

        private bool testVehicule(string nom)
        {
            string[] NomVehicule = {"ADMIRAL",
                                    "AIRTUG",
                                    "AMBULANCE",
                                    "BANSHEE",
                                    "BENSON",
                                    "BIFF",
                                    "BLISTA",
                                    "BOBCAT",
                                    "BOXVILLE",
                                    "BUCCANEER",
                                    "BURRITO",
                                    "BURRITO2",
                                    "BUS",
                                    "CABBY",
                                    "CAVCADE",
                                    "CHAVOS",
                                    "COGNOS",
                                    "COMET",
                                    "CONTENDER",
                                    "COQUETTE",
                                    "DF8",
                                    "DILETT",
                                    "DUKES",
                                    "EMPEROR",
                                    "EMPEROR2",
                                    "ESPERANT",
                                    "FACTION",
                                    "FBI",
                                    "FELTZER",
                                    "FEROCI",
                                    "FIRETRUK",    
                                    "FLATBED",    
                                    "FORTUNE",    
                                    "FORKLIFT",	
                                    "FUTO",       
                                    "FXT", 	   
                                    "HABANERO",	
                                    "HAKUMAI",	   
                                    "HUNTLEY",	   
                                    "INFERNUS",	
                                    "INGOT",	  
                                    "INTRUDER",  
                                    "LANSTALK",   
                                    "LOKUS",	   
                                    "MANANA",   
                                    "MARBELLA",   
                                    "MERIT",     
                                    "MINIVAN",    
                                    "MOONBEAM",   
                                    "MRTASTY",   
                                    "MULE",     
                                    "NOOSE",    
                                    "ORACLE",   
                                    "PACKER",    
                                    "PATRIOT", 	
                                    "PERENNIAL", 
                                    "PEYOTE",	  
                                    "PHANTOM",  
                                    "PINNACLE",   
                                    "PMP600",    
                                    "POLICE", 
                                    "POLICE2",   
                                    "POLPAT",  
                                    "PONY",      
                                    "PREMIER",	 
                                    "PRES",   
                                    "PRIMO",  
                                    "RANCHER",	  
                                    "REBLA",	
                                    "RIPLEY",   
                                    "ROMAN",    
                                    "ROMERO",    
                                    "RUINER",   
                                    "SABRE",    
                                    "SABRE2",   
                                    "SABREGT",    
                                    "SCHAFTER",   
                                    "SENTINEL",   
                                    "SOLAIR",    
                                    "SPEEDO",    
                                    "STALLION",	
                                    "STEED",     
                                    "STOCKADE",    
                                    "STRATUM",  
                                    "STRETCH",	   
                                    "SULTAN",	  
                                    "SULTANRS", 
                                    "SUPERGT",		
                                    "SWAT",     
                                    "TAXI",     
                                    "TAXI2",     
                                    "TRASH",     
                                    "TURISMO",		
                                    "URANUS",	 
                                    "VIGERO",    
                                    "VIGERO2",  
                                    "VINCENT",    
                                    "VIRGO",    
                                    "VOODOO",     
                                    "WASHINGTON", 
                                    "WILLARD",  
                                    "YANKEE",    
                                    "CABLECAR", 
                                    "SUBWAY",    
                                    "BOBBER",	    
                                    "FAGGIO",	  
                                    "HELLFURY",   
                                    "NRG900",	  
                                    "PCJ",	   
                                    "SANCHEZ",	  
                                    "ZOMBIE",	   
                                    "DINGHY",   
                                    "JETMAX",     
                                    "MARQUIS",   
                                    "PREDATOR",  
                                    "REEFER",     
                                    "SQUALO",   
                                    "TROPIC",   
                                    "TUG",		
                                    "ANNHIL",  
                                    "MAVERICK", 
                                    "POLMAV",
                                    "TOURMAV",
                                    "ANDROM",
                                    "DODO",
                                    "FIGHTER"};

            for (int i = 0; i < 126; i++)
            {
                if (nom == NomVehicule[i])
                    return true;
            }
            return false;

        }

        private void Form1_Load(object sender, EventArgs e)
        {
            try
            {
                RegistryKey cle = Registry.LocalMachine;
                RegistryKey subcle = cle.OpenSubKey(@"SOFTWARE\Rockstar Games\Grand Theft Auto IV", false);
                directory = subcle.GetValue("InstallFolder").ToString();
                cle.Close();

                Directory.CreateDirectory(directory + @"\common\data\HandlingChanger");
                if (File.Exists(directory + @"\common\data\HandlingChanger\handling.dat"))
                {
                }
                else
                {
                    File.Copy(directory + @"\common\data\handling.dat", directory + @"\common\data\HandlingChanger\handling.dat", false);
                    File.Copy(directory + @"\common\data\carcols.dat", directory + @"\common\data\HandlingChanger\carcols.dat", false);
                    File.Copy(directory + @"\common\data\vehicles.ide", directory + @"\common\data\HandlingChanger\vehicles.ide", false);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Erreur");
                this.Close();
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                string handling = directory + @"\common\data\handling.dat";
                string[] vehicule = textBox1.Text.Split();
                bool VehiculeValide = false;

                File.SetAttributes(handling, FileAttributes.Normal);

                StreamReader FichierHandling = new StreamReader(handling);

                string ligne = FichierHandling.ReadLine();
                string contenu = "";
                VehiculeValide = testVehicule(vehicule[0]);
                if (VehiculeValide == true)
                {
                    while (ligne != null)
                    {
                        if (ligne.Contains(vehicule[0]))
                        {
                            ligne = textBox1.Text;
                        }
                        contenu += ligne + "\r\n";
                        ligne = FichierHandling.ReadLine();
                    }
                    FichierHandling.Close();

                    StreamWriter Ecrire = new StreamWriter(handling);
                    Ecrire.Write(contenu);
                    Ecrire.Close();

                    MessageBox.Show("Handling.dat modifié");
                    textBox1.Text = "";
                }
                else
                    MessageBox.Show("Handling invalide");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Erreur");
            }
            textBox1.Text = "";
        }

        private void btnCarcols_Click(object sender, EventArgs e)
        {
            try
            {
                string carcols = directory + @"\common\data\carcols.dat";
                string[] vehicule = textBox2.Text.Split();
                bool VehiculeValide = false;

                File.SetAttributes(carcols, FileAttributes.Normal);

                StreamReader FichierCarcols = new StreamReader(carcols);

                if (textBox2.Text != "")
                {
                    string ligne = FichierCarcols.ReadLine();
                    string contenu = "";
                    string nomVehicule = vehicule[0].Remove((vehicule[0].Length) - 1);
                    nomVehicule = nomVehicule.ToUpper();
                    VehiculeValide = testVehicule(nomVehicule);
                    if (VehiculeValide == true)
                    {
                        while (ligne != null)
                        {
                            if (ligne.Contains(vehicule[0]))
                            {
                                ligne = textBox2.Text;
                            }
                            contenu += ligne + "\r\n";
                            ligne = FichierCarcols.ReadLine();
                        }
                        FichierCarcols.Close();

                        StreamWriter Ecrire = new StreamWriter(carcols);
                        Ecrire.Write(contenu);
                        Ecrire.Close();

                        MessageBox.Show("Carcols.dat modifié");
                        textBox2.Text = "";
                    }
                    else
                        MessageBox.Show("Carcols invalide");
                }
                else
                    MessageBox.Show("Carcols invalide");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Erreur");
            }
            textBox2.Text = "";
        }

        private void button1_Click_1(object sender, EventArgs e)
        {
            try
            {
                string vehicles = directory + @"\common\data\vehicles.ide";
                string[] vehicule = textBox3.Text.Split();
                bool VehiculeValide = false;

                File.SetAttributes(vehicles, FileAttributes.Normal);

                StreamReader FichierVehicles = new StreamReader(vehicles);

                string ligne = FichierVehicles.ReadLine();
                string contenu = "";
                if (textBox3.Text != "")
                {
                    string nomVehicule = vehicule[0].Remove((vehicule[0].Length) - 1);
                    nomVehicule = nomVehicule.ToUpper();
                    VehiculeValide = testVehicule(nomVehicule);

                    if (VehiculeValide == true)
                    {
                        while (ligne != null)
                        {
                            if (ligne.Contains(vehicule[0]))
                            {
                                ligne = textBox3.Text;
                            }
                            contenu += ligne + "\r\n";
                            ligne = FichierVehicles.ReadLine();
                        }
                        FichierVehicles.Close();

                        StreamWriter Ecrire = new StreamWriter(vehicles);
                        Ecrire.Write(contenu);
                        Ecrire.Close();

                        MessageBox.Show("Vehicules.ide modifié");
                        textBox3.Text = "";
                    }
                    else
                        MessageBox.Show("Vehicules invalide");
                }
                else
                    MessageBox.Show("Vehicules invalide");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Erreur");
            }
            textBox3.Text = "";
        }
    }
}
